const Sanitizer = require("./Sanitizer");

const ConstraintBuilder = () => { }

function getParamConstraint(param, columnName, tbl) {
    let orConstraint = ' ';
    let inOperator = "";
    let isNull = "";

    if (param.length > 0) {
        if (columnName == "marca_temporal") {
            for (const paramValue of param) {
                if (paramValue == 'Vacíos') {
                    orConstraint += ` ${tbl}.${columnName} IS NULL `;
                } else {
                    const sanitizedValue = Sanitizer.run(paramValue);
                    orConstraint += ` ${tbl}.${columnName} LIKE '%${sanitizedValue}%' OR`;
                }
            }
            orConstraint += orConstraint.substring(0, orConstraint.length - 2);
        } else {
            let filters = [];

            filters = param.filter((pm) => pm != "Vacíos");
            if (param.includes("Vacíos")) {
                isNull = ` ${tbl}.${columnName} IS NULL `
            }

            for (const paramValue of filters) {
                const sanitizedValue = Sanitizer.run(paramValue);
                inOperator += `'${sanitizedValue}',`
            }

            if (inOperator.length > 0) {
                inOperator = inOperator.substring(0, inOperator.length - 1);
                inOperator = `(${inOperator})`;
            }
            orConstraint += ` ${isNull.length > 0 ? isNull : ""} ${isNull.length > 0 && inOperator.length > 0 ? "OR" : ""} ${inOperator.length > 0 ? tbl + "." + columnName + " IN " + inOperator : ""}`;
        }
    }

    return orConstraint;
}

/**
 * @param {import("express").Request} request
 * @param {{}} allowedParams
 */
ConstraintBuilder.whereConstraints = (request, allowedParams, tableName) => {
    const queryParams = request.query;
    const { month, year } = queryParams;

    let where = {
        query: '',
        dateRange: '',
        values: [],
    };

    let whereConstraint = '';
    let useAnd = false;
    let passed = false;

    // Base query in case there is no filter selected
    let selectQuery = `SELECT * FROM (
      SELECT * FROM ${tableName}  ORDER BY created_at DESC
      ) AS main_${tableName}`;

    // Dynamically create subqueries for each filter provided
    let tblNo = 1;
    for (const [param, columnName] of Object.entries(allowedParams)) {
        let paramValues = queryParams[param];


        if (paramValues != undefined) {
            if (!Array.isArray(paramValues)) {
                paramValues = [paramValues];
            }

            // Get constraints
            whereConstraint = getParamConstraint(paramValues, columnName, `tbl_${tblNo}`);

            if (!passed) {
                selectQuery = ` SELECT main_tbl_${tblNo}.* FROM (
                    SELECT * FROM ${tableName} AS tbl_${tblNo} WHERE ${whereConstraint} ORDER BY created_at DESC
                    ) AS main_tbl_${tblNo}`;
                passed = true;
            } else {
                selectQuery = ` SELECT tbl_${tblNo}.* FROM ( ${selectQuery} ) AS tbl_${tblNo} WHERE ${whereConstraint}`;
                useAnd = true;
            }

            tblNo++;
        }
    }

    // Date constraints
    if (month) {
        const monthYear = `${year}-${month}`;
        let strDate = `${year}-${month}-01 00:00:00`;
        let monthDays = new Date(year, month, 0);

        where.values.push(strDate, `${monthYear}-${monthDays.getDate()} 23:59:59`);

        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN ? AND ? `;
    }

    if (year && !month) {
        where.values.push(`${year}-01-01 00:00:00`, `${year}-12-31 23:59:59`);
        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN ? AND ? `;
    }

    where.query = selectQuery;

    return where;
}

module.exports = ConstraintBuilder;