const ConstraintBuilder = require("../utils/ConstraintBuilder");

const Licitacion = () => { }

/**
 * @param {import("express").Request} request
 * @returns
 */
Licitacion.whereConstraints = (request) => {
    const allowedParams = {
        'assign_follower': 'designated_user_id',
        'assign_seller': 'user_id',
        'partidas': 'partidas',
        'tmpMarca': 'marca_temporal',
        'nombre': 'nombre',
        'dependencia_lic': 'dependencia_licitante',
        'dependencia_usu': 'dependencia_usuario',
        'empresas': 'empresa_participantes',
        'fechas_pub': 'fecha_publicacion',
        'lugares_pub': 'donde_se_publico',
        'fecha_envio_pre': 'fecha_envio_preguntas',
        'hora_limite_enviop': 'hora_limite_envio_preguntas',
        'como_se_entrega': 'como_se_entregan',
        'domicilio_correo': 'domicilio_correo',
        'fecha_junta_acl': 'fecha_junta_aclaraciones',
        'hora_registro_ja': 'hora_registro_ja',
        'hora_ja': 'hora_ja',
        'junta_obligatoria': 'junta_obligatoria',
        'domicilio_junta': 'domicilio_ja',
        'tipo_junta': 'presencial_digital',
        'domicilio': 'domicilio',
        'fecha_pre': 'fecha_presentacion',
        'hora_registro_pre': 'hora_registro_presentacion',
        'hora_apertura': 'hora_apertura',
        'requiere_preventa': 'requiere_preventa',
        'final_status': 'estatus_final',
        'presentation_status': 'estatus_presentacion',
        'estatus_preguntas': 'estatus_preguntas',
        'estatus_ficha': 'estatus_ficha',
    };

    return ConstraintBuilder.whereConstraints(request, allowedParams, 'licitaciones');
}

module.exports = Licitacion;