const DashboardFilters = () => { };

DashboardFilters.whereConstraintD = (queryParams) => {
    const { month, year,rangestart,rangeend } = queryParams;

    
    let where = {
        query: '',
        dateRange: '',
        values: [],
    };

    let useAnd = false;
    
    if (rangestart) {
        where.dateRange = `where created_at BETWEEN '${rangestart}' and '${rangeend}' `;
    }else if (month) {
        const monthYear = `${year}-${month}`;
        let strDate = `${year}-${month}-01 00:00:00`;
        let monthDays = new Date(year, month, 0);

        where.values.push(strDate, `${monthYear}-${monthDays.getDate()} 23:59:59`);

        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at like '${monthYear}%' `;
    }else if (year && !month) {
        where.values.push(`${year}-01-01 00:00:00`, `${year}-12-31 23:59:59`);
        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN '${year}-01-01 00:00:00' AND '${year}-12-31 23:59:59' `;
    }
    return where;
}

module.exports = DashboardFilters;