const express = require("express");
const mysql = require("mysql2/promise");
const cors = require("cors");
const { format } = require("date-fns");
const bodyParser = require("body-parser");
const nodemailer = require('nodemailer');
const path = require('path');
const fs = require('fs');
const dayjs = require('dayjs');
const https = require('https');
const moment = require('moment-timezone');

const privateKey = `-----BEGIN RSA PRIVATE KEY-----
MIIEpQIBAAKCAQEAxhUj6j34OBOeg+h8gOBi7q7I1AmVWIuFqPppbQg2M6Mr3bpp
96QgHApgKEM3aV45rj4fB4ZkqEdSmG2YfiPZanUcU0gPs3RWvy/dVco5pOIK0SAq
fKf8K6LIwCDsfacc+gbTXm4yVX/z0Xo18a0C9NnNXFTtwXL5b226rs8tzcU7s9ln
ezwglR536fxjXik+e3INcbELIyxo0h4pI1nHKbtK9EK6jRqcFfdEbV8HJK7AU/6K
fEqBU1R/JgJOuuMVCVe2lYl91QF3q+ze0cNQr2+468eJNcP2afJdrZREppLBJRVC
m3DINGywpin2QGcsM+Lczyp7Lt+rvx6dAYHItwIDAQABAoIBAQCx2atcl3V2DA+I
ika3hEDv45lH4K7qSKOi2+uqzPO1m204cTbR9dgqtRovLGLlRYfurbI4lG9uNFOx
rr17jH6aujnLgOkwDGYS1Uwayi7Fn3ts1z+umzmsiEVNVIJiM5it2VEQ+UpSQEdP
rzYeH2SHKcPcghjTV4MkjFZQvI54sGauZ+nWNprPwFeaKrvnG1d+y0cZti4ItbLr
QKUuPWhnJc+Xm3VfDS5e3LaeqqZr0UWztZxhEQ2g4a1aMVX8omyB0ebDpGsyOAlW
Una0XWK25pZCndOxd28sDX2kQK0Z8K7+tptFUkeKNdrGbh602vw9aXxWJMRbMnPe
dQhCo3TpAoGBAPsAdsRaiXuOaHhF6behU9rYIzA4AbDaEGyvl2OYLVQyPTVTCYD9
N1Vy8Tm0+tmcRQEkHe3yFGiGR0IXSwJVM6YYEoMV6STXOdReos7CUa86aYYnj48Q
dSDKzKEqwGbFWrtxKuBQLYHL9PuVD1tbQIhDSUe/pytcyI4NLah7JE6jAoGBAMoG
6LvEzI1XGHaZtD75bVWRT4+Ksg40Fqyq8cslzZLZf7MeRGE5UWU9C83kuOwKtrOd
VyjVc8557tTYQLFTc0cOMyOzBMtHG4XhwePdHb9Ih5v/N1qJFCsx79AArv6CuKR7
w74LE5tG083qfSLNaCwmWRLBFb7AW7YDT2g1KuLdAoGBAMI+CKtJmU2J1mUFTaoy
6e7ZBtpA7WYMS1ugw1pqoOGgg2ep3Bf7XX/+FJng6aPP4ELSzWqfxZViHPETj5O9
ldu6k1DoeuVsva8QkZPKI2akoJcWNG21gb8f0h4DNKQTpHScTl8LDTx+NxcesqSz
SIxq7eHdeiP/iKENp8DTkzRbAoGAJAO1S3vaxzuGheYCptNKNV3RJBKiiTup6yAS
OJfFnO8e/6xenkJci0Klrw+eE54ZUc2zsvjSSzWbaOAgMDxjKYCTh0KrkR1c/7Hu
IZPScL4aRqnpkT8slEKzsI3epEpjZhcWHvPUi/LFYUjzA9hAQNaZPGmlWbrq3nia
mEYaHhUCgYEAx6ZHJiKtBBEXIHPzoHavSetZqcsYmcpq/lPco/oLcAY5PXhdHvgd
qKJW/3mY8yoiG/FF0DR2pxJAk+WcqDztyJ6BfY3sQBgrfAXoSHd2tId1np74XoKa
Gel0wHWCZP/3Gky1w0gqj7JwwPZgGZybDr8NGIwXHsueTxBrDn/Y7Yk=
-----END RSA PRIVATE KEY-----`;

const certificate = `-----BEGIN CERTIFICATE-----
MIIFKDCCBBCgAwIBAgISBBBx707UQe+gLhfMPZOqxodLMA0GCSqGSIb3DQEBCwUA
MDIxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1MZXQncyBFbmNyeXB0MQswCQYDVQQD
EwJSMzAeFw0yMzA4MDQyMDIxMThaFw0yMzExMDIyMDIxMTdaMCMxITAfBgNVBAMM
GCoudGVjbm9sb2dpYWludGVncmFkYS5teDCCASIwDQYJKoZIhvcNAQEBBQADggEP
ADCCAQoCggEBAMYVI+o9+DgTnoPofIDgYu6uyNQJlViLhaj6aW0INjOjK926afek
IBwKYChDN2leOa4+HweGZKhHUphtmH4j2Wp1HFNID7N0Vr8v3VXKOaTiCtEgKnyn
/CuiyMAg7H2nHPoG015uMlV/89F6NfGtAvTZzVxU7cFy+W9tuq7PLc3FO7PZZ3s8
IJUed+n8Y14pPntyDXGxCyMsaNIeKSNZxym7SvRCuo0anBX3RG1fBySuwFP+inxK
gVNUfyYCTrrjFQlXtpWJfdUBd6vs3tHDUK9vuOvHiTXD9mnyXa2URKaSwSUVQptw
yDRssKYp9kBnLDPi3M8qey7fq78enQGByLcCAwEAAaOCAkUwggJBMA4GA1UdDwEB
/wQEAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDAYDVR0TAQH/
BAIwADAdBgNVHQ4EFgQUZKQfianFEYLey6edgriguI73OaEwHwYDVR0jBBgwFoAU
FC6zF7dYVsuuUAlA5h+vnYsUwsYwVQYIKwYBBQUHAQEESTBHMCEGCCsGAQUFBzAB
hhVodHRwOi8vcjMuby5sZW5jci5vcmcwIgYIKwYBBQUHMAKGFmh0dHA6Ly9yMy5p
LmxlbmNyLm9yZy8wUAYDVR0RBEkwR4IYKi50ZWNub2xvZ2lhaW50ZWdyYWRhLm14
git3d3cuZWFzeXNlYXJjaHBydWViYS50ZWNub2xvZ2lhaW50ZWdyYWRhLm14MBMG
A1UdIAQMMAowCAYGZ4EMAQIBMIIBAgYKKwYBBAHWeQIEAgSB8wSB8ADuAHUAejKM
VNi3LbYg6jjgUh7phBZwMhOFTTvSK8E6V6NS61IAAAGJwm0gWQAABAMARjBEAiAb
y0KmYNH5znr2cUO0XObBNV7s9c1VJ9aTEMIc4sZJ6AIgIKriiboQvmkhm6RlGHTZ
6+JVCwEdZJ7w8tgRLQ/qqwAAdQCt9776fP8QyIudPZwePhhqtGcpXc+xDCTKhYY0
69yCigAAAYnCbSB2AAAEAwBGMEQCIFkq53ej6VOJGQUJkEdX5ni57qNKTJZoU25j
AvTvOOZAAiBtiMWpNeqGqQibP6tRJcqXD7bMYBbwn2HBz474ykVjUDANBgkqhkiG
9w0BAQsFAAOCAQEARiL3mv01oXIHwDUkfmuO2t/Z8SvOyy7u1ZgevdLP9lW5HY9C
ZHJ+9KQvdEdPh03qy5tj+B2vuWi8NtpLy0i4NRsu9XAzsynrHezz4DGigDeCRp91
fIt7prXg8IImolxJq/jcv8slqFKaR3TxJz64+NJbvNWJoC2ftUzXUkbKZz3HEMN2
dGIb1tlTYL9fOepKLeh/qeCiMEdHttIhi76RXrJH7SNuG8bpOUNpqql6xEkMm93r
Oj6y6QrX8hBb9R7xAvOVsv5pJE0TgAN7DMuUKHliwwL02/KIdKZ93vzouThF/65k
uT/MZSp1/XaaXjFnafhmBgyyaCoOi8esPiDDdg==
-----END CERTIFICATE-----`;

const options = {
  key: privateKey,
  cert: certificate,
};

// Crear la aplicación Express
const app = express();

app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());

// Crear conexión a la base de datos
const connection = mysql.createPool({
  host: "localhost",
  port: "3306",
  user: "tecnosvv_buscadorati",
  password: "buscadorati2559",
  database: "tecnosvv_buscador",
});

// Middleware para habilitar CORS
app.use(cors());

// Middleware para procesar JSON en las solicitudes
app.use(express.json());
// Definir la configuración de la base de datos
const dbConfig = {
  host: "localhost",
  port: "3306",
  user: "tecnosvv_buscadorati",
  password: "buscadorati2559",
  database: "tecnosvv_buscador",
};

// Crear la conexión a la base de datos
const createConnection = async () => {
  const connection = await mysql.createConnection(dbConfig);
  return connection;
};

//Ruta para actualizar los correos
app.put('/actualizar-correo/:correo', async (req, res) => {
  const correoActual = req.params.correo;
  const nuevoCorreo = req.body.nuevo_correo; // Campo esperado para el nuevo correo

  try {
    const connection = await createConnection();

    await connection.execute('UPDATE correos_destino SET correo = ? WHERE correo = ?', [nuevoCorreo, correoActual]);
    res.send('Correo actualizado correctamente');

    connection.end();
  } catch (error) {
    console.error('Error al actualizar el correo en la base de datos', error);
    res.status(500).send('Error al actualizar el correo en la base de datos');
  }
});

// Ruta para eliminar un correo
app.delete('/eliminar-correo/:correo', async (req, res) => {
  const correo = req.params.correo;

  try {
    const connection = await createConnection();

    await connection.execute('DELETE FROM correos_destino WHERE correo = ?', [correo]);
    res.send('Correo eliminado correctamente');

    connection.end();
  } catch (error) {
    console.error('Error al eliminar el correo en la base de datos', error);
    res.status(500).send('Error al eliminar el correo en la base de datos');
  }
});

// Ruta para obtener los correos
app.get('/obtener-correos', async (req, res) => {
  try {
    const connection = await createConnection();

    const [rows] = await connection.execute('SELECT correo FROM correos_destino');
    const correos = rows.map((row) => row.correo);

    res.json(correos);

    connection.end();
  } catch (error) {
    console.error('Error al obtener los correos desde la base de datos', error);
    res.status(500).send('Error al obtener los correos desde la base de datos');
  }
});

// Ruta para enviar correos
app.post('/enviar-correos', async (req, res) => {
  const correosDestino = req.body.correosDestino;
  const mensaje = req.body.mensaje.replace(/\n/g, '<br>');
  const asunto = req.body.asunto;

  const transporter = nodemailer.createTransport({
    host: 'easysearch.tecnologiaintegrada.mx',
    port: 465,
    secure: true,
    auth: {
      user: 'licitaciones@easysearch.tecnologiaintegrada.mx',
      pass: '7vAY5LNS=NL;',
    },
  });

  function enviarCorreo(correoDestino) {
    const mailOptions = {
      from: 'licitaciones@easysearch.tecnologiaintegrada.mx',
      to: correoDestino,
      subject: asunto,
      html: `${mensaje}<br><img src="https://i.postimg.cc/sgxWRXPD/buscador-y-comparador.jpg">`, // Reemplaza URL_DE_LA_IMAGEN con la URL real de la imagen externa
    };

    return new Promise((resolve, reject) => {
      transporter.sendMail(mailOptions, (error, info) => {
        if (error) {
          console.error(error);
          reject(error);
        } else {
          console.log('Correo enviado:', info.response);
          resolve(info.response);
        }
      });
    });
  }

  try {
    const connection = await createConnection();

    const [rows] = await connection.execute('SELECT correo FROM correos_destino');
    const correosRegistrados = rows.map((row) => row.correo);

    const correosParaEnviar = correosDestino.concat(correosRegistrados);

    Promise.all(correosParaEnviar.map(enviarCorreo))
      .then(() => {
        res.send('Correo(s) enviado(s)');
      })
      .catch((error) => {
        console.error('Error al enviar el correo', error);
        res.status(500).send('Error al enviar el correo');
      });

    connection.end();
  } catch (error) {
    console.error('Error al obtener los correos desde la base de datos', error);
    res.status(500).send('Error al obtener los correos desde la base de datos');
  }
});

// Ruta para guardar un correo
app.post('/guardar-correo', async (req, res) => {
  const correo = req.body.correo;

  try {
    const connection = await createConnection();

    await connection.execute('INSERT INTO correos_destino (correo) VALUES (?)', [correo]);
    res.send('Correo guardado correctamente');

    connection.end();
  } catch (error) {
    console.error('Error al guardar el correo en la base de datos', error);
    res.status(500).send('Error al guardar el correo en la base de datos');
  }
});

// Endpoint para enviar un mensaje de correo que se gano la licitación
app.post('/enviar-correos-gano', async (req, res) => {
  const correosDestino = req.body.correosDestino;
  const mensaje = req.body.mensaje.replace(/\n/g, '<br>');
  const asunto = req.body.asunto;

  const transporter = nodemailer.createTransport({
    host: 'easysearch.tecnologiaintegrada.mx',
    port: 465,
    secure: true,
    auth: {
      user: 'licitaciones@easysearch.tecnologiaintegrada.mx',
      pass: '7vAY5LNS=NL;',
    },
  });

  function enviarCorreo(correoDestino) {
    const mailOptions = {
      from: 'licitaciones@easysearch.tecnologiaintegrada.mx',
      to: correoDestino,
      subject: asunto,
      html: `${mensaje}<br><img src="https://i.postimg.cc/sgxWRXPD/buscador-y-comparador.jpg">`, // Reemplaza URL_DE_LA_IMAGEN con la URL real de la imagen externa
    };

    return new Promise((resolve, reject) => {
      transporter.sendMail(mailOptions, (error, info) => {
        if (error) {
          console.error(error);
          reject(error);
        } else {
          console.log('Correo enviado:', info.response);
          resolve(info.response);
        }
      });
    });
  }

  try {
    const connection = await createConnection();

    const [rows] = await connection.execute('SELECT correo FROM correos_destino');
    const correosRegistrados = rows.map((row) => row.correo);

    const correosParaEnviar = [...correosDestino, ...correosRegistrados];

    Promise.all(correosParaEnviar.map(enviarCorreo))
      .then(() => {
        res.send('Correo(s) enviado(s)');
      })
      .catch((error) => {
        console.error('Error al enviar el correo', error);
        res.status(500).send('Error al enviar el correo');
      });

    connection.end();
  } catch (error) {
    console.error('Error al obtener los correos desde la base de datos', error);
    res.status(500).send('Error al obtener los correos desde la base de datos');
  }
});

/// Endpoint para enviar un mensaje de correo que fue desierta la licitación
app.post('/enviar-correos-desierta', (req, res) => {
  const correosDestino = Array.isArray(req.body.correosDestino) ? req.body.correosDestino : [req.body.correosDestino]; // Array de direcciones de correo electrónico
  const mensaje = req.body.mensaje.replace(/\n/g, '<br>'); // Reemplaza los saltos de línea con <br>
  const asunto = req.body.asunto;

  // Configuración del transportador de correo
  const transporter = nodemailer.createTransport({
    host: 'easysearch.tecnologiaintegrada.mx', // Reemplaza con la dirección del servidor SMTP
    port: 465, // Reemplaza con el puerto del servidor SMTP
    secure: true, // Si el servidor utiliza SSL/TLS, cambia a true
    auth: {
      user: 'licitaciones@easysearch.tecnologiaintegrada.mx', // Reemplaza con tu dirección de correo electrónico
      pass: '7vAY5LNS=NL;', // Reemplaza con tu contraseña
    },
  });

  // Función auxiliar para enviar un correo electrónico
  function enviarCorreo(correoDestino) {
    const mailOptions = {
      from: 'licitaciones@easysearch.tecnologiaintegrada.mx',
      to: correoDestino,
      subject: asunto,
      html: `${mensaje}<br><img src="https://i.postimg.cc/sgxWRXPD/buscador-y-comparador.jpg">`, // Reemplaza URL_DE_LA_IMAGEN con la URL real de la imagen externa
    };

    return new Promise((resolve, reject) => {
      // Envío del correo electrónico
      transporter.sendMail(mailOptions, (error, info) => {
        if (error) {
          console.error(error);
          reject(error);
        } else {
          console.log('Correo enviado:', info.response);
          resolve(info.response);
        }
      });
    });
  }

  // Envía el correo electrónico a cada destinatario
  Promise.all(correosDestino.map(enviarCorreo))
    .then(() => {
      res.send('Correo(s) enviado(s)');
    })
    .catch((error) => {
      res.status(500).send('Error al enviar el correo');
    });
});

/// Endpoint para enviar un mensaje de correo que se perdio la licitación
app.post('/enviar-correos-perdio', (req, res) => {
  const correosDestino = Array.isArray(req.body.correosDestino) ? req.body.correosDestino : [req.body.correosDestino]; // Array de direcciones de correo electrónico
  const mensaje = req.body.mensaje.replace(/\n/g, '<br>'); // Reemplaza los saltos de línea con <br>
  const asunto = req.body.asunto;

  // Configuración del transportador de correo
  const transporter = nodemailer.createTransport({
    host: 'easysearch.tecnologiaintegrada.mx', // Reemplaza con la dirección del servidor SMTP
    port: 465, // Reemplaza con el puerto del servidor SMTP
    secure: true, // Si el servidor utiliza SSL/TLS, cambia a true
    auth: {
      user: 'licitaciones@easysearch.tecnologiaintegrada.mx', // Reemplaza con tu dirección de correo electrónico
      pass: '7vAY5LNS=NL;', // Reemplaza con tu contraseña
    },
  });

  // Función auxiliar para enviar un correo electrónico
  function enviarCorreo(correoDestino) {
    const mailOptions = {
      from: 'licitaciones@easysearch.tecnologiaintegrada.mx',
      to: correoDestino,
      subject: asunto,
      html: `${mensaje}<br><img src="https://i.postimg.cc/sgxWRXPD/buscador-y-comparador.jpg">`, // Reemplaza URL_DE_LA_IMAGEN con la URL real de la imagen externa
    };

    return new Promise((resolve, reject) => {
      // Envío del correo electrónico
      transporter.sendMail(mailOptions, (error, info) => {
        if (error) {
          console.error(error);
          reject(error);
        } else {
          console.log('Correo enviado:', info.response);
          resolve(info.response);
        }
      });
    });
  }

  // Envía el correo electrónico a cada destinatario
  Promise.all(correosDestino.map(enviarCorreo))
    .then(() => {
      res.send('Correo(s) enviado(s)');
    })
    .catch((error) => {
      res.status(500).send('Error al enviar el correo');
    });
});

// Ruta para guardar un nuevo registro
app.post("/api/registros", async (req, res) => {
  try {
    // Obtener los datos del cuerpo de la solicitud
    const {
      nombreLicitacion,
      dependenciaLicitante,
      dependenciaUsuario,
      empresaParticipantes,
      fechaPublicacion,
      dondePublicado,
      fechaEnvioPreguntas,
      horaLimiteEnvioPreguntas,
      comoSeEntregan,
      domicilioCorreo,
      fechaJuntaAclaraciones,
      horaRegistroJA,
      horaJA,
      juntaObligatoria,
      domicilioJA,
      presencialOdigital,
      domicilio,
      fechaPresentacion,
      horaRegistroPresentacion,
      horaApertura,
      partidas,
      requierePreventa,
      linkCarpeta,
    } = req.body;

    // Establecer la zona horaria para México
    moment.tz.setDefault('America/Mexico_City'); // Puedes ajustar la zona horaria según sea necesario

    // Obtener la hora actual con la zona horaria configurada
    const marcaTemporal = moment().format('YYYY-MM-DD HH:mm:ss');


    // Consulta SQL para insertar un nuevo registro
    const query = `
      INSERT INTO licitaciones (
        marca_temporal,
        nombre,
        dependencia_licitante,
        dependencia_usuario,
        empresa_participantes,
        fecha_publicacion,
        donde_se_publico,
        fecha_envio_preguntas,
        hora_limite_envio_preguntas,
        como_se_entregan,
        domicilio_correo,
        fecha_junta_aclaraciones,
        hora_registro_ja,
        hora_ja,
        junta_obligatoria,
        domicilio_ja,
        presencial_digital,
        domicilio,
        fecha_presentacion,
        hora_registro_presentacion,
        hora_apertura,
        partidas,
        requiere_preventa,
        link_carpeta
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    `;

    const values = [
      marcaTemporal,
      nombreLicitacion,
      dependenciaLicitante,
      dependenciaUsuario,
      empresaParticipantes,
      fechaPublicacion,
      dondePublicado,
      fechaEnvioPreguntas,
      horaLimiteEnvioPreguntas,
      comoSeEntregan,
      domicilioCorreo,
      fechaJuntaAclaraciones,
      horaRegistroJA,
      horaJA,
      juntaObligatoria,
      domicilioJA,
      presencialOdigital,
      domicilio,
      fechaPresentacion,
      horaRegistroPresentacion,
      horaApertura,
      partidas,
      requierePreventa,
      linkCarpeta,
    ];

    // Ejecutar la consulta SQL
    await connection.query(query, values);

    // Enviar respuesta exitosa
    res.status(201).json({ message: "Registro guardado exitosamente" });
  } catch (error) {
    console.error("Error al guardar el registro", error);
    res.status(500).json({ error: "Error al guardar el registro" });
  }
});

// Ruta para obtener todos los registros
app.get("/api/registros", async (req, res) => {
  try {
    // Consulta SQL para obtener todos los registros
    const query = "SELECT * FROM licitaciones";

    // Ejecutar la consulta SQL
    const [rows] = await connection.query(query);

    // Formatear las fechas al formato deseado (YYYY-MM-DD) en los registros obtenidos
    const formattedRows = rows.map((row) => {
      return {
        ...row,
        marca_temporal: format(
          new Date(row.marca_temporal),
          "dd-MM-yyyy HH:mm"
        ),
        fecha_publicacion: format(
          new Date(row.fecha_publicacion),
          "dd-MM-yyyy"
        ),
        fecha_envio_preguntas: format(
          new Date(row.fecha_envio_preguntas),
          "dd-MM-yyyy"
        ),
        fecha_junta_aclaraciones: format(
          new Date(row.fecha_junta_aclaraciones),
          "dd-MM-yyyy"
        ),
        fecha_presentacion: format(
          new Date(row.fecha_presentacion),
          "dd-MM-yyyy"
        ),
      };
    });

    // Enviar los registros formateados como respuesta
    res.status(200).json(formattedRows);
  } catch (error) {
    console.error("Error al obtener los registros", error);
    res.status(500).json({ error: "Error al obtener los registros" });
  }
});

app.post("/api/estatus/observaciones", async (req, res) => {
  try {
    const { id, estatus} = req.body;

    const query =
      "UPDATE licitaciones SET observaciones = ? WHERE id = ?"; 
    const values = [estatus, id];

    await connection.query(query, values);

    res.status(200).json({ message: "Estatus de preguntas actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estatus de preguntas", error);
    res.status(500).json({ error: "Error al actualizar el estatus de preguntas" });
  }
});

app.post("/api/estatus/preguntas", async (req, res) => {
  try {
    const { id, estatus, usuarioPreguntas } = req.body; // Agregar "usuarioPreguntas" al destructuring

    const fechaHora = dayjs(); // Obtenemos la fecha y hora actual con dayjs
    const formattedFechaHora = fechaHora.format('YYYY-MM-DD HH:mm:ss'); // Formato para columna de tipo DATETIME

    const query =
      "UPDATE licitaciones SET estatus_preguntas = ?, fecha_hora_guardado_preguntas = ?, usuario_preguntas = ? WHERE id = ?"; // Actualizar la consulta SQL con el nuevo campo "usuario_preguntas"
    const values = [estatus, formattedFechaHora, usuarioPreguntas, id]; // Incluir "usuarioPreguntas" en los valores

    await connection.query(query, values);

    res.status(200).json({ message: "Estatus de preguntas actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estatus de preguntas", error);
    res.status(500).json({ error: "Error al actualizar el estatus de preguntas" });
  }
});


// Ruta para guardar el estatus de la junta
app.post("/api/estatus/junta", async (req, res) => {
  try {
    const { id, estatus, usuarioJunta } = req.body;
    const fechaHora = dayjs();

    const formattedFechaHora = fechaHora.format('YYYY-MM-DD HH:mm:ss');

    const query = "UPDATE licitaciones SET estatus_junta = ?, fecha_hora_guardado_junta = ?, usuario_junta = ? WHERE id = ?";
    const values = [estatus, formattedFechaHora, usuarioJunta, id];

    await connection.query(query, values);

    res
      .status(200)
      .json({ message: "Estatus de junta actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estatus de junta", error);
    res.status(500).json({ error: "Error al actualizar el estatus de junta" });
  }
});

// Ruta para guardar el estatus de la presentación
app.post("/api/estatus/presentacion", async (req, res) => {
  try {
    const { id, estatus, usuarioPresentacion } = req.body;
    const fechaHora = dayjs();

    const formattedFechaHora = fechaHora.format('YYYY-MM-DD HH:mm:ss');

    const query =
      "UPDATE licitaciones SET estatus_presentacion = ?, fecha_hora_guardado_presentacion = ?, usuario_presentacion = ? WHERE id = ?";
    const values = [estatus, formattedFechaHora, usuarioPresentacion,  id];

    await connection.query(query, values);

    res
      .status(200)
      .json({ message: "Estatus de presentación actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estatus de presentación", error);
    res
      .status(500)
      .json({ error: "Error al actualizar el estatus de presentación" });
  }
});

// Ruta para guardar el estatus de la ficha tecnica
app.post("/api/estatus/ficha", async (req, res) => {
  try {
    const { id, estatus, usuarioFicha } = req.body; // Agregar "usuarioPreguntas" al destructuring

    const fechaHora = dayjs(); // Obtenemos la fecha y hora actual con dayjs
    const formattedFechaHora = fechaHora.format('YYYY-MM-DD HH:mm:ss'); // Formato para columna de tipo DATETIME

    const query =
      "UPDATE licitaciones SET estatus_ficha = ?, fecha_hora_guardado_ficha = ?, usuario_ficha = ? WHERE id = ?"; // Actualizar la consulta SQL con el nuevo campo "usuario_preguntas"
    const values = [estatus, formattedFechaHora, usuarioFicha, id]; // Incluir "usuarioPreguntas" en los valores

    await connection.query(query, values);

    res.status(200).json({ message: "Estatus de ficha actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estatus de ficha", error);
    res.status(500).json({ error: "Error al actualizar el estatus de preguntas" });
  }
});

// Ruta para obtener los valores de estatus de un registro específico
app.get("/api/estatus/:id", async (req, res) => {
  try {
    const { id } = req.params;

    const query =
      "SELECT observaciones, estatus_preguntas, estatus_junta, estatus_presentacion, estatus_ficha FROM licitaciones WHERE id = ?";
    const values = [id];

    const [rows] = await connection.query(query, values);

    const estatus = {
      observaciones: rows[0].observaciones,
      estatusPreguntas: rows[0].estatus_preguntas,
      estatusJunta: rows[0].estatus_junta,
      estatusPresentacion: rows[0].estatus_presentacion,
      estatusFicha: rows[0].estatus_ficha,
    };

    res.status(200).json(estatus);
  } catch (error) {
    console.error("Error al obtener los valores de estatus", error);
    res.status(500).json({ error: "Error al obtener los valores de estatus" });
  }
});

// Ruta para guardar el estatus final
app.post("/api/estatus/final", async (req, res) => {
  try {
    const { id, estatus, usuarioFinal } = req.body;
    const fechaHora = dayjs();

    const formattedFechaHora = fechaHora.format('YYYY-MM-DD HH:mm:ss');

    const query = "UPDATE licitaciones SET estatus_final = ?, fecha_hora_guardado_final = ?, usuario_final = ? WHERE id = ?";
    const values = [estatus, formattedFechaHora, usuarioFinal, id];

    await connection.query(query, values);

    res.status(200).json({ message: "Estatus final actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estatus final", error);
    res.status(500).json({ error: "Error al actualizar el estatus final" });
  }
});

// Ruta para obtener el estatus final de un registro
app.get("/api/estatus/final/:id", async (req, res) => {
  try {
    const { id } = req.params;

    const query = "SELECT estatus_final FROM licitaciones WHERE id = ?";
    const values = [id];

    const [rows] = await connection.query(query, values);

    const estatusFinal = rows[0].estatus_final;

    res.status(200).json({ estatusFinal });
  } catch (error) {
    console.error("Error al obtener el estatus final", error);
    res.status(500).json({ error: "Error al obtener el estatus final" });
  }
});

// Ruta para guardar el estado de deshabilitación
app.post("/api/estatus/deshabilitar", async (req, res) => {
  try {
    const { id, deshabilitado } = req.body;

    const query =
      "UPDATE licitaciones SET deshabilitado = ? WHERE id = ?";
    const values = [deshabilitado, id];

    await connection.query(query, values);

    res.status(200).json({ message: "Estado de deshabilitación actualizado exitosamente" });
  } catch (error) {
    console.error("Error al actualizar el estado de deshabilitación", error);
    res.status(500).json({ error: "Error al actualizar el estado de deshabilitación" });
  }
});

// Ruta para obtener el estado de deshabilitación de un registro
app.get("/api/estatus/deshabilitar/:id", async (req, res) => {
  try {
    const { id } = req.params;

    const query = "SELECT deshabilitado FROM licitaciones WHERE id = ?";
    const values = [id];

    const [rows] = await connection.query(query, values);

    const deshabilitado = rows[0].deshabilitado;

    res.status(200).json({ deshabilitado });
  } catch (error) {
    console.error("Error al obtener el estado de deshabilitación", error);
    res.status(500).json({ error: "Error al obtener el estado de deshabilitación" });
  }
});

app.post("/api/rows", async (req, res) => {
  try {
    const { id, color, estatusFinal } = req.body;

    const query =
      "INSERT INTO colors (row_id, color, estatus_final) VALUES (?, ?, ?)";
    const values = [id, String(color), estatusFinal];

    await connection.query(query, values);

    res.status(201).json({ message: "Color guardado exitosamente" });
  } catch (error) {
    console.error("Error al guardar el color", error);
    res.status(500).json({ error: "Error al guardar el color" });
  }
});

// Ruta para obtener los colores de las filas
app.get("/api/rows/colors", async (req, res) => {
  try {
    const query = "SELECT row_id, color FROM colors";

    const [rows] = await connection.query(query);

    const colors = rows.reduce((acc, row) => {
      acc[row.row_id] = row.color;
      return acc;
    }, {});

    res.status(200).json(colors);
  } catch (error) {
    console.error("Error al obtener los colores de las filas", error);
    res
      .status(500)
      .json({ error: "Error al obtener los colores de las filas" });
  }
});

// Iniciar el servidor HTTPS
const port = 3200;
const hostname = 'easysearchnode.tecnologiaintegrada.mx';

const server = https.createServer(options, app);

server.listen(port, () => {
  console.log(`Servidor HTTPS iniciado en https://${hostname}:${port}/`);
});