"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Autopilot
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FieldValuePage = exports.FieldValueListInstance = exports.FieldValueInstance = exports.FieldValueContextImpl = void 0;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../../../base/Page"));
const deserialize = require("../../../../../base/deserialize");
const serialize = require("../../../../../base/serialize");
const utility_1 = require("../../../../../base/utility");
class FieldValueContextImpl {
    constructor(_version, assistantSid, fieldTypeSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assistantSid)) {
            throw new Error("Parameter 'assistantSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(fieldTypeSid)) {
            throw new Error("Parameter 'fieldTypeSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { assistantSid, fieldTypeSid, sid };
        this._uri = `/Assistants/${assistantSid}/FieldTypes/${fieldTypeSid}/FieldValues/${sid}`;
    }
    remove(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new FieldValueInstance(operationVersion, payload, instance._solution.assistantSid, instance._solution.fieldTypeSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FieldValueContextImpl = FieldValueContextImpl;
class FieldValueInstance {
    constructor(_version, payload, assistantSid, fieldTypeSid, sid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.fieldTypeSid = payload.field_type_sid;
        this.language = payload.language;
        this.assistantSid = payload.assistant_sid;
        this.sid = payload.sid;
        this.value = payload.value;
        this.url = payload.url;
        this.synonymOf = payload.synonym_of;
        this._solution = { assistantSid, fieldTypeSid, sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new FieldValueContextImpl(this._version, this._solution.assistantSid, this._solution.fieldTypeSid, this._solution.sid);
        return this._context;
    }
    /**
     * Remove a FieldValueInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a FieldValueInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed FieldValueInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            fieldTypeSid: this.fieldTypeSid,
            language: this.language,
            assistantSid: this.assistantSid,
            sid: this.sid,
            value: this.value,
            url: this.url,
            synonymOf: this.synonymOf,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FieldValueInstance = FieldValueInstance;
function FieldValueListInstance(version, assistantSid, fieldTypeSid) {
    if (!(0, utility_1.isValidPathParam)(assistantSid)) {
        throw new Error("Parameter 'assistantSid' is not valid.");
    }
    if (!(0, utility_1.isValidPathParam)(fieldTypeSid)) {
        throw new Error("Parameter 'fieldTypeSid' is not valid.");
    }
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new FieldValueContextImpl(version, assistantSid, fieldTypeSid, sid);
    };
    instance._version = version;
    instance._solution = { assistantSid, fieldTypeSid };
    instance._uri = `/Assistants/${assistantSid}/FieldTypes/${fieldTypeSid}/FieldValues`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["language"] === null || params["language"] === undefined) {
            throw new Error("Required parameter \"params['language']\" missing.");
        }
        if (params["value"] === null || params["value"] === undefined) {
            throw new Error("Required parameter \"params['value']\" missing.");
        }
        let data = {};
        data["Language"] = params["language"];
        data["Value"] = params["value"];
        if (params["synonymOf"] !== undefined)
            data["SynonymOf"] = params["synonymOf"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new FieldValueInstance(operationVersion, payload, instance._solution.assistantSid, instance._solution.fieldTypeSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["language"] !== undefined)
            data["Language"] = params["language"];
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new FieldValuePage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new FieldValuePage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.FieldValueListInstance = FieldValueListInstance;
class FieldValuePage extends Page_1.default {
    /**
     * Initialize the FieldValuePage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of FieldValueInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new FieldValueInstance(this._version, payload, this._solution.assistantSid, this._solution.fieldTypeSid);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FieldValuePage = FieldValuePage;
