const Sanitizer = require("../utils/Sanitizer");
const EstudyMarket = () => {};
function getParamConstraint(param, columnName, tbl) {
  let orConstraint = " ";
  let inOperator = "";
  let isNull = "";

  if (param.length > 0) {
    if (columnName == "marca_temporal") {
      for (const paramValue of param) {
        if (paramValue == "Vacíos") {
          orConstraint += ` ${tbl}.${columnName} IS NULL `;
        } else {
          const sanitizedValue = Sanitizer.run(paramValue);
          orConstraint += ` ${tbl}.${columnName} LIKE '%${sanitizedValue}%' OR`;
        }
      }
      orConstraint += orConstraint.substring(0, orConstraint.length - 2);
    } else {
      let filters = [];

      filters = param.filter((pm) => pm != "Vacíos");
      if (param.includes("Vacíos")) {
        isNull = ` ${tbl}.${columnName} IS NULL `;
      }

      for (const paramValue of filters) {
        const sanitizedValue = Sanitizer.run(paramValue);
        inOperator += `'${sanitizedValue}',`;
      }

      if (inOperator.length > 0) {
        inOperator = inOperator.substring(0, inOperator.length - 1);
        inOperator = `(${inOperator})`;
      }
      orConstraint += ` ${isNull.length > 0 ? isNull : ""} ${
        isNull.length > 0 && inOperator.length > 0 ? "OR" : ""
      } ${
        inOperator.length > 0
          ? tbl + "." + columnName + " IN " + inOperator
          : ""
      }`;
    }
  }

  return orConstraint;
}
EstudyMarket.whereConstraint = (queryParams) => {
  const allowedParams = {
    sucursal: "sucursal",
    marca_temporal: "marca_temporal",
    preventa_asiganado: "preventa_asiganado",
    preventa_acompaniante: "preventa_acompaniante",
    empresa_cotiza: "empresa_cotiza",
    fecha_entrega: "fecha_entrega",
    estatus: "estatus",
  };
  const { month, year } = queryParams;

  let where = {
    query: "",
    dateRange: "",
    values: [],
  };

  let useAnd = false;
  let passed = false;

  // Base query in case there is no filter selected
  let selectQuery = `SELECT * FROM (
      SELECT  id,
      user_id,
      designated_user_id,
      usuario,
      sucursal,
      dependencia,
      marca_temporal,
      vendedor,
      preventa_asiganado,
      preventa_acompaniante,
      empresa_cotiza,
      tipo_solucion_requerida,
      requiere_oportunidad_fabricante,
      numero_oportunidad,
      fecha_entrega,
      link_folder,
      observation,
      created_at,
      updated_at,
      usuario_update_status,
      updated_at_status,
      usuario_update_preven,
      update_at_prev,
      COALESCE(estatus , 'No atendidos') AS estatus FROM estudio_mercado  ORDER BY created_at DESC
      ) AS main_estudio_market`;

  // Dynamically create subqueries for each filter provided
  let tblNo = 1;
  for (const [param, columnName] of Object.entries(allowedParams)) {
    let paramValues = queryParams[param];

    if (paramValues != undefined) {
      if (!Array.isArray(paramValues)) {
        paramValues = [paramValues];
      }

      // Get constraints
      whereConstraint = getParamConstraint(
        paramValues,
        columnName,
        `tbl_${tblNo}`
      );

      if (!passed) {
        selectQuery = ` SELECT main_tbl_${tblNo}.* FROM (
                    SELECT  id,
                    user_id,
                    designated_user_id,
                    usuario,
                    sucursal,
                    dependencia,
                    marca_temporal,
                    vendedor,
                    preventa_asiganado,
                    preventa_acompaniante,
                    empresa_cotiza,
                    tipo_solucion_requerida,
                    requiere_oportunidad_fabricante,
                    numero_oportunidad,
                    fecha_entrega,
                    link_folder,
                    observation,
                    created_at,
                    updated_at,
                    usuario_update_status,
                    updated_at_status,
                    usuario_update_preven,
                    update_at_prev,
                    COALESCE(estatus , 'No atendidos') AS estatus FROM estudio_mercado AS tbl_${tblNo} WHERE ${whereConstraint} ORDER BY created_at DESC
                    ) AS main_tbl_${tblNo}`;
        passed = true;
      } else {
        selectQuery = ` SELECT tbl_${tblNo}.* FROM ( ${selectQuery} ) AS tbl_${tblNo} WHERE ${whereConstraint}`;
        useAnd = true;
      }

      tblNo++;
    }
  }
  // Date constraints
  if (month) {
    const monthYear = `${year}-${month}`;
    let strDate = `${year}-${month}-01 00:00:00`;
    let monthDays = new Date(year, month, 0);

    where.values.push(strDate, `${monthYear}-${monthDays.getDate()} 23:59:59`);

    where.dateRange = ` ${
      useAnd ? "AND" : "WHERE"
    } created_at BETWEEN ? AND ?  `;
  }

  if (year && !month) {
    where.values.push(`${year}-01-01 00:00:00`, `${year}-12-31 23:59:59`);
    where.dateRange = ` ${
      useAnd ? "AND" : "WHERE"
    } created_at  BETWEEN ? AND ?  `;
  }
  where.query = selectQuery;
  return where;
};

module.exports = EstudyMarket;
