const express = require("express");
const mysql = require("mysql2/promise");
const cors = require("cors");
const { format } = require("date-fns");
const bodyParser = require("body-parser");
const https = require('https');

const privateKey = `-----BEGIN RSA PRIVATE KEY-----
MIIEpQIBAAKCAQEAxhUj6j34OBOeg+h8gOBi7q7I1AmVWIuFqPppbQg2M6Mr3bpp
96QgHApgKEM3aV45rj4fB4ZkqEdSmG2YfiPZanUcU0gPs3RWvy/dVco5pOIK0SAq
fKf8K6LIwCDsfacc+gbTXm4yVX/z0Xo18a0C9NnNXFTtwXL5b226rs8tzcU7s9ln
ezwglR536fxjXik+e3INcbELIyxo0h4pI1nHKbtK9EK6jRqcFfdEbV8HJK7AU/6K
fEqBU1R/JgJOuuMVCVe2lYl91QF3q+ze0cNQr2+468eJNcP2afJdrZREppLBJRVC
m3DINGywpin2QGcsM+Lczyp7Lt+rvx6dAYHItwIDAQABAoIBAQCx2atcl3V2DA+I
ika3hEDv45lH4K7qSKOi2+uqzPO1m204cTbR9dgqtRovLGLlRYfurbI4lG9uNFOx
rr17jH6aujnLgOkwDGYS1Uwayi7Fn3ts1z+umzmsiEVNVIJiM5it2VEQ+UpSQEdP
rzYeH2SHKcPcghjTV4MkjFZQvI54sGauZ+nWNprPwFeaKrvnG1d+y0cZti4ItbLr
QKUuPWhnJc+Xm3VfDS5e3LaeqqZr0UWztZxhEQ2g4a1aMVX8omyB0ebDpGsyOAlW
Una0XWK25pZCndOxd28sDX2kQK0Z8K7+tptFUkeKNdrGbh602vw9aXxWJMRbMnPe
dQhCo3TpAoGBAPsAdsRaiXuOaHhF6behU9rYIzA4AbDaEGyvl2OYLVQyPTVTCYD9
N1Vy8Tm0+tmcRQEkHe3yFGiGR0IXSwJVM6YYEoMV6STXOdReos7CUa86aYYnj48Q
dSDKzKEqwGbFWrtxKuBQLYHL9PuVD1tbQIhDSUe/pytcyI4NLah7JE6jAoGBAMoG
6LvEzI1XGHaZtD75bVWRT4+Ksg40Fqyq8cslzZLZf7MeRGE5UWU9C83kuOwKtrOd
VyjVc8557tTYQLFTc0cOMyOzBMtHG4XhwePdHb9Ih5v/N1qJFCsx79AArv6CuKR7
w74LE5tG083qfSLNaCwmWRLBFb7AW7YDT2g1KuLdAoGBAMI+CKtJmU2J1mUFTaoy
6e7ZBtpA7WYMS1ugw1pqoOGgg2ep3Bf7XX/+FJng6aPP4ELSzWqfxZViHPETj5O9
ldu6k1DoeuVsva8QkZPKI2akoJcWNG21gb8f0h4DNKQTpHScTl8LDTx+NxcesqSz
SIxq7eHdeiP/iKENp8DTkzRbAoGAJAO1S3vaxzuGheYCptNKNV3RJBKiiTup6yAS
OJfFnO8e/6xenkJci0Klrw+eE54ZUc2zsvjSSzWbaOAgMDxjKYCTh0KrkR1c/7Hu
IZPScL4aRqnpkT8slEKzsI3epEpjZhcWHvPUi/LFYUjzA9hAQNaZPGmlWbrq3nia
mEYaHhUCgYEAx6ZHJiKtBBEXIHPzoHavSetZqcsYmcpq/lPco/oLcAY5PXhdHvgd
qKJW/3mY8yoiG/FF0DR2pxJAk+WcqDztyJ6BfY3sQBgrfAXoSHd2tId1np74XoKa
Gel0wHWCZP/3Gky1w0gqj7JwwPZgGZybDr8NGIwXHsueTxBrDn/Y7Yk=
-----END RSA PRIVATE KEY-----`;

const certificate = `-----BEGIN CERTIFICATE-----
MIIFKDCCBBCgAwIBAgISBBBx707UQe+gLhfMPZOqxodLMA0GCSqGSIb3DQEBCwUA
MDIxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1MZXQncyBFbmNyeXB0MQswCQYDVQQD
EwJSMzAeFw0yMzA4MDQyMDIxMThaFw0yMzExMDIyMDIxMTdaMCMxITAfBgNVBAMM
GCoudGVjbm9sb2dpYWludGVncmFkYS5teDCCASIwDQYJKoZIhvcNAQEBBQADggEP
ADCCAQoCggEBAMYVI+o9+DgTnoPofIDgYu6uyNQJlViLhaj6aW0INjOjK926afek
IBwKYChDN2leOa4+HweGZKhHUphtmH4j2Wp1HFNID7N0Vr8v3VXKOaTiCtEgKnyn
/CuiyMAg7H2nHPoG015uMlV/89F6NfGtAvTZzVxU7cFy+W9tuq7PLc3FO7PZZ3s8
IJUed+n8Y14pPntyDXGxCyMsaNIeKSNZxym7SvRCuo0anBX3RG1fBySuwFP+inxK
gVNUfyYCTrrjFQlXtpWJfdUBd6vs3tHDUK9vuOvHiTXD9mnyXa2URKaSwSUVQptw
yDRssKYp9kBnLDPi3M8qey7fq78enQGByLcCAwEAAaOCAkUwggJBMA4GA1UdDwEB
/wQEAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDAYDVR0TAQH/
BAIwADAdBgNVHQ4EFgQUZKQfianFEYLey6edgriguI73OaEwHwYDVR0jBBgwFoAU
FC6zF7dYVsuuUAlA5h+vnYsUwsYwVQYIKwYBBQUHAQEESTBHMCEGCCsGAQUFBzAB
hhVodHRwOi8vcjMuby5sZW5jci5vcmcwIgYIKwYBBQUHMAKGFmh0dHA6Ly9yMy5p
LmxlbmNyLm9yZy8wUAYDVR0RBEkwR4IYKi50ZWNub2xvZ2lhaW50ZWdyYWRhLm14
git3d3cuZWFzeXNlYXJjaHBydWViYS50ZWNub2xvZ2lhaW50ZWdyYWRhLm14MBMG
A1UdIAQMMAowCAYGZ4EMAQIBMIIBAgYKKwYBBAHWeQIEAgSB8wSB8ADuAHUAejKM
VNi3LbYg6jjgUh7phBZwMhOFTTvSK8E6V6NS61IAAAGJwm0gWQAABAMARjBEAiAb
y0KmYNH5znr2cUO0XObBNV7s9c1VJ9aTEMIc4sZJ6AIgIKriiboQvmkhm6RlGHTZ
6+JVCwEdZJ7w8tgRLQ/qqwAAdQCt9776fP8QyIudPZwePhhqtGcpXc+xDCTKhYY0
69yCigAAAYnCbSB2AAAEAwBGMEQCIFkq53ej6VOJGQUJkEdX5ni57qNKTJZoU25j
AvTvOOZAAiBtiMWpNeqGqQibP6tRJcqXD7bMYBbwn2HBz474ykVjUDANBgkqhkiG
9w0BAQsFAAOCAQEARiL3mv01oXIHwDUkfmuO2t/Z8SvOyy7u1ZgevdLP9lW5HY9C
ZHJ+9KQvdEdPh03qy5tj+B2vuWi8NtpLy0i4NRsu9XAzsynrHezz4DGigDeCRp91
fIt7prXg8IImolxJq/jcv8slqFKaR3TxJz64+NJbvNWJoC2ftUzXUkbKZz3HEMN2
dGIb1tlTYL9fOepKLeh/qeCiMEdHttIhi76RXrJH7SNuG8bpOUNpqql6xEkMm93r
Oj6y6QrX8hBb9R7xAvOVsv5pJE0TgAN7DMuUKHliwwL02/KIdKZ93vzouThF/65k
uT/MZSp1/XaaXjFnafhmBgyyaCoOi8esPiDDdg==
-----END CERTIFICATE-----`;

const options = {
  key: privateKey,
  cert: certificate,
};

// Crear la aplicación Express
const app = express();

app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());

// Crear conexin a la base de datos
const connection = mysql.createPool({
  host: "localhost",
  port: "3306",
  user: "tecnosvv_buscadorati",
  password: "buscadorati2559",
  database: "tecnosvv_buscador",
});

// Middleware para habilitar CORS
app.use(cors());

app.post("/api/registroPreventa", async (req, res) => {
    try {
      const {
        nameClient,
        job,
        decisions,
        phone,
        mail,
        companyName,
        address,
        bussinesDescription,
        problem,
        budgetIP,
        solution,
        brands,
        brandPreference,
        infrastructureIP,
        additionalInfo
      } = req.body;
  
      const query = `
      INSERT INTO ip_preventa (
        marca_temporal,
        nombre_cliente,
        puesto,
        decisiones,
        telefono,
        correo,
        nombre_empresa,
        direccion,
        descripcion_negocio,
        problema,
        presupuesto,
        solucion,
        marcas,
        preferencia_marcas,
        infraestructura_ti,
        informacion_adicional
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
      `;
  
      const values = [
        new Date(),
        nameClient,
        job,
        decisions,
        phone,
        mail,
        companyName,
        address,
        bussinesDescription,
        problem,
        budgetIP,
        solution,
        brands,
        brandPreference,
        infrastructureIP,
        additionalInfo
      ];
      await connection.query(query, values);
  
      res.status(201).json({ message: "Rigistro guardado exitosamente"});
    } catch (error) {
      console.error("Error al guardar el registro", error);
      res.status(500).json({error: "Error al guardar el registro"});
    }
  });
  
  app.post("/api/actualizarObservacionesIP", async (req, res) => {
    try {
      const { id, observacionesIP } = req.body;
      
      console.log("Id:", id);
      console.log("Observaciones1:", observacionesIP);
      console.log("Observaciones2:", observacionesIP);
  
      const query = "UPDATE ip_preventa SET observaciones = ? WHERE id = ?";
  
      const values = [
        observacionesIP,
        id,
      ];
      await connection.query(query, values);
  
      res.status(200).json({ message: "Observaciones actualizadas exitosamente" });
    } catch (error) {
      console.error("Error al actualizar las observaciones", error);
      res.status(500).json({ error: "Error al actualizar las observaciones" });
    }
  });
  
  app.get("/api/consultaPreventa", async (req, res) => {
    try {
      const query = "SELECT * FROM ip_preventa";
      const [rows] = await connection.query(query);
  
      const formattedRows = rows.map((row) => {
        return {
          ...row,
          marca_temporal: format(
            new Date(row.marca_temporal),
            "dd-MM-yyyy HH:mm"
          ),
        };
      });
      res.status(200).json(formattedRows);
    } catch (error) {
      console.error("Error al obtener los registros", error);
      res.status(500).json({error: "Error al obtener los registros"});
    }
  });
  
  app.post("/api/rowsPreventa", async (req, res) => {
    try {
      const { id, color, estatusFinalP } = req.body;
  
      const query =
        "INSERT INTO colorsPreventa (row_id, color, estatus_final) VALUES (?, ?, ?)";
      const values = [id, String(color), estatusFinalP];
  
      await connection.query(query, values);
  
      res.status(201).json({ message: "Color guardado exitosamente" });
    } catch (error) {
      console.error("Error al guardar el color", error);
      res.status(500).json({ error: "Error al guardar el color" });
    }
  });
  
  app.post("/api/estatusPreventa", async (req, res) => {
    try {
      const { id, estatusP} = req.body;
  
      const query = "UPDATE ip_preventa SET estatus = ? WHERE id = ?";
      const values = [estatusP, id];
  
      await connection.query(query, values);
  
      res.status(200).json({ message: "Estatus final actualizado exitosamente" });
    } catch (error) {
      console.error("Error al actualizar el estatus final", error);
      res.status(500).json({ error: "Error al actualizar el estatus final" });
    }
  });

  // Iniciar el servidor HTTPS
const port = 3000;
const hostname = 'easysearchnode.tecnologiaintegrada.mx';

const server = https.createServer(options, app);

server.listen(port, () => {
  console.log(`Servidor HTTPS iniciado en https://${hostname}:${port}/`);
});