const Sanitizer = require("../utils/Sanitizer");

const Licitacion = () => { }

function getParamConstraint(param, columnName, tbl) {
    let orConstraint = ' ';
    let inOperator = "";
    let isNull = "";

    if (param.length > 0) {
        if (columnName == "marca_temporal") {
            for (const paramValue of param) {
                if (paramValue == 'Vacíos') {
                    orConstraint += ` ${tbl}.${columnName} IS NULL `;
                } else {
                    const sanitizedValue = Sanitizer.run(paramValue);
                    orConstraint += ` ${tbl}.${columnName} LIKE '%${sanitizedValue}%' OR`;
                }
            }
            orConstraint += orConstraint.substring(0, orConstraint.length - 2);
        } else {
            let filters = [];

            filters = param.filter((pm) => pm != "Vacíos");
            if (param.includes("Vacíos")) {
                isNull = ` ${tbl}.${columnName} IS NULL `
            }

            for (const paramValue of filters) {
                const sanitizedValue = Sanitizer.run(paramValue);
                inOperator += `'${sanitizedValue}',`
            }

            if (inOperator.length > 0) {
                inOperator = inOperator.substring(0, inOperator.length - 1);
                inOperator = `(${inOperator})`;
            }
            orConstraint += ` ${isNull.length > 0 ? isNull : ""} ${isNull.length > 0 && inOperator.length > 0 ? "OR" : ""} ${inOperator.length > 0 ? tbl + "." + columnName + " IN " + inOperator : ""}`;
        }
    }

    return orConstraint;
}

Licitacion.whereConstraints = (queryParams) => {
    const allowedParams = {
        'partidas': 'partidas',
        'tmpMarca': 'marca_temporal',
        'nombre': 'nombre',
        'dependencia_lic': 'dependencia_licitante',
        'dependencia_usu': 'dependencia_usuario',
        'empresas': 'empresa_participantes',
        'fechas_pub': 'fecha_publicacion',
        'lugares_pub': 'donde_se_publico',
        'fecha_envio_pre': 'fecha_envio_preguntas',
        'hora_limite_enviop': 'hora_limite_envio_preguntas',
        'como_se_entrega': 'como_se_entregan',
        'domicilio_correo': 'domicilio_correo',
        'fecha_junta_acl': 'fecha_junta_aclaraciones',
        'hora_registro_ja': 'hora_registro_ja',
        'hora_ja': 'hora_ja',
        'junta_obligatoria': 'junta_obligatoria',
        'domicilio_junta': 'domicilio_ja',
        'tipo_junta': 'presencial_digital',
        'domicilio': 'domicilio',
        'fecha_pre': 'fecha_presentacion',
        'hora_registro_pre': 'hora_registro_presentacion',
        'hora_apertura': 'hora_apertura',
        'requiere_preventa': 'requiere_preventa',
        'final_status': 'estatus_final',
        'presentation_status': 'estatus_presentacion',
        'estatus_preguntas': 'estatus_preguntas',
        'estatus_ficha': 'estatus_ficha',
    };
    const { month, year } = queryParams;

    let where = {
        query: '',
        dateRange: '',
        values: [],
    };

    let whereConstraint = '';
    let useAnd = false;
    let passed = false;

    // Base query in case there is no filter selected
    let selectQuery = `SELECT * FROM (
      SELECT * FROM licitaciones  ORDER BY created_at DESC
      ) AS main_licitaciones`;

    // Dynamically create subqueries for each filter provided
    let tblNo = 1;
    for (const [param, columnName] of Object.entries(allowedParams)) {
        let paramValues = queryParams[param];


        if (paramValues != undefined) {
            if (!Array.isArray(paramValues)) {
                paramValues = [paramValues];
            }

            // Get constraints
            whereConstraint = getParamConstraint(paramValues, columnName, `tbl_${tblNo}`);

            if (!passed) {
                selectQuery = ` SELECT main_tbl_${tblNo}.* FROM (
                    SELECT * FROM licitaciones AS tbl_${tblNo} WHERE ${whereConstraint} ORDER BY created_at DESC
                    ) AS main_tbl_${tblNo}`;
                passed = true;
            } else {
                selectQuery = ` SELECT tbl_${tblNo}.* FROM ( ${selectQuery} ) AS tbl_${tblNo} WHERE ${whereConstraint}`;
                useAnd = true;
            }

            tblNo++;
        }
    }

    // Date constraints
    if (month) {
        const monthYear = `${year}-${month}`;
        let strDate = `${year}-${month}-01 00:00:00`;
        let monthDays = new Date(year, month, 0);

        where.values.push(strDate, `${monthYear}-${monthDays.getDate()} 23:59:59`);

        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN ? AND ? `;
    }

    if (year && !month) {
        where.values.push(`${year}-01-01 00:00:00`, `${year}-12-31 23:59:59`);
        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN ? AND ? `;
    }

    where.query = selectQuery;

    return where;
}

module.exports = Licitacion;