const Education = () => { }

Education.whereConstraint = (queryParams) => {
    const { month, year } = queryParams;

    let where = {
        query: '',
        dateRange: '',
        values: [],
    };

    let useAnd = false;

    // Date constraints
    if (month) {
        const monthYear = `${year}-${month}`;
        let strDate = `${year}-${month}-01 00:00:00`;
        let monthDays = new Date(year, month, 0);

        where.values.push(strDate, `${monthYear}-${monthDays.getDate()} 23:59:59`);

        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN ? AND ? `;
    }

    if (year && !month) {
        where.values.push(`${year}-01-01 00:00:00`, `${year}-12-31 23:59:59`);
        where.dateRange = ` ${useAnd ? 'AND' : 'WHERE'} created_at BETWEEN ? AND ? `;
    }

    return where;
}

module.exports = Education;